/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.ffmpeg.Frame;
import com.github.kokorin.jaffree.ffmpeg.FrameConsumer;
import com.github.kokorin.jaffree.ffmpeg.FrameOutput;
import com.github.kokorin.jaffree.ffmpeg.ImageFormat;
import com.github.kokorin.jaffree.ffmpeg.Stream;
import com.github.kokorin.jaffree.nut.MainHeader;
import com.github.kokorin.jaffree.nut.NutFrame;
import com.github.kokorin.jaffree.nut.NutInputStream;
import com.github.kokorin.jaffree.nut.NutReader;
import com.github.kokorin.jaffree.nut.StreamHeader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutFrameReader
implements FrameOutput.FrameReader {
    private final FrameConsumer frameConsumer;
    private final ImageFormat imageFormat;
    private static final Logger LOGGER = LoggerFactory.getLogger(NutFrameReader.class);

    public NutFrameReader(FrameConsumer frameConsumer, ImageFormat imageFormat) {
        this.frameConsumer = frameConsumer;
        this.imageFormat = imageFormat;
    }

    @Override
    public void read(InputStream input) throws IOException {
        NutFrame nutFrame;
        NutInputStream stream = new NutInputStream(input);
        NutReader nutReader = new NutReader(stream);
        MainHeader mainHeader = nutReader.getMainHeader();
        StreamHeader[] streamHeaders = nutReader.getStreamHeaders();
        List<Stream> streams = NutFrameReader.parseTracks(mainHeader, streamHeaders);
        this.frameConsumer.consumeStreams(streams);
        LOGGER.debug("Streams: {}", (Object)streamHeaders);
        while ((nutFrame = nutReader.readFrame()) != null) {
            LOGGER.trace("NutFrame: {}", (Object)nutFrame);
            int trackNo = nutFrame.streamId;
            Frame frame = this.parseFrame(streamHeaders[trackNo], nutFrame);
            LOGGER.trace("Parsed frame: {}", (Object)frame);
            if (frame == null) continue;
            this.frameConsumer.consume(frame);
        }
        this.frameConsumer.consume(null);
    }

    private static List<Stream> parseTracks(MainHeader mainHeader, StreamHeader[] streamHeaders) {
        ArrayList<Stream> result = new ArrayList<Stream>();
        for (StreamHeader streamHeader : streamHeaders) {
            Stream stream = null;
            if (streamHeader.streamType == StreamHeader.Type.VIDEO) {
                stream = new Stream().setType(Stream.Type.VIDEO).setWidth(streamHeader.video.width).setHeight(streamHeader.video.height);
            } else if (streamHeader.streamType == StreamHeader.Type.AUDIO) {
                Rational samplerate = streamHeader.audio.sampleRate;
                if (samplerate.getDenominator() != 1L) {
                    LOGGER.warn("Audio samplerate should be integer but it is ({}).", (Object)samplerate);
                }
                stream = new Stream().setType(Stream.Type.AUDIO).setSampleRate(samplerate.longValue()).setChannels(streamHeader.audio.channelCount);
            }
            if (stream == null) continue;
            Rational timebase = mainHeader.timeBases[streamHeader.timeBaseId];
            stream.setId(streamHeader.streamId).setTimebase(timebase.getDenominator() / timebase.getNumerator());
            result.add(stream);
        }
        return result;
    }

    private Frame parseFrame(StreamHeader track, NutFrame frame) {
        if (frame == null || frame.data == null || frame.data.length == 0 || frame.eor) {
            return null;
        }
        BufferedImage image = null;
        int[] samples = null;
        if (track.streamType == StreamHeader.Type.VIDEO) {
            int width = track.video.width;
            int height = track.video.height;
            if (frame.data.length == width * height * this.imageFormat.getBytesPerPixel()) {
                image = this.imageFormat.toImage(frame.data, width, height);
            }
        } else if (track.streamType == StreamHeader.Type.AUDIO) {
            ByteBuffer data = ByteBuffer.wrap(frame.data);
            IntBuffer intData = data.asIntBuffer();
            samples = new int[intData.limit()];
            intData.get(samples);
        }
        if (image != null || samples != null) {
            return new Frame(track.streamId, frame.pts, image, samples);
        }
        return null;
    }
}

