/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Apply a colormap to a label map and superimpose it on an image.


Apply a colormap to a label map and put it on top of the feature
image. The feature image is typically the image from which the
labeling was produced. Use the SetInput function to set the LabelMap , and the SetFeatureImage function to set the feature image.

The set of colors is a good selection of distinct colors. The opacity
of the label map can be defined by the user. A background label
produce a gray pixel with the same intensity than the input one.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


See:
 LabelOverlayImageFilter , LabelOverlayFunctor

 LabelMapToRGBImageFilter , LabelMapToBinaryImageFilter , LabelMapToLabelImageFilter

 itk::simple::LabelMapOverlay for the procedural interface

 itk::LabelMapOverlayImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelMapOverlayImageFilter.h
*/
public class LabelMapOverlayImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelMapOverlayImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelMapOverlayImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelMapOverlayImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelMapOverlayImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelMapOverlayImageFilter::~LabelMapOverlayImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelMapOverlayImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelMapOverlayImageFilter::LabelMapOverlayImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelMapOverlayImageFilter() {
    this(SimpleITKJNI.new_LabelMapOverlayImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelMapOverlayImageFilter::SetOpacity(double Opacity)

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public  void setOpacity(double Opacity) {
    SimpleITKJNI.LabelMapOverlayImageFilter_setOpacity(swigCPtr, this, Opacity);
  }

  /**
double itk::simple::LabelMapOverlayImageFilter::GetOpacity() const

Set/Get the opacity of the colored label image. The value must be
between 0 and 1

*/
public  double getOpacity() {
    return SimpleITKJNI.LabelMapOverlayImageFilter_getOpacity(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelMapOverlayImageFilter::SetColormap(std::vector&lt; unsigned char &gt; Colormap)
*/
public  void setColormap(VectorUInt8 Colormap) {
    SimpleITKJNI.LabelMapOverlayImageFilter_setColormap(swigCPtr, this, VectorUInt8.getCPtr(Colormap), Colormap);
  }

  /**
std::vector&lt;unsigned char&gt; itk::simple::LabelMapOverlayImageFilter::GetColormap() const
*/
public  VectorUInt8 getColormap() {
    return new VectorUInt8(SimpleITKJNI.LabelMapOverlayImageFilter_getColormap(swigCPtr, this), true);
  }

  /**
std::string itk::simple::LabelMapOverlayImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelMapOverlayImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelMapOverlayImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelMapOverlayImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LabelMapOverlayImageFilter::Execute(const Image &amp;labelMapImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image labelMapImage, Image featureImage) {
    return new Image(SimpleITKJNI.LabelMapOverlayImageFilter_execute(swigCPtr, this, Image.getCPtr(labelMapImage), labelMapImage, Image.getCPtr(featureImage), featureImage), true);
  }

}
